#!/bin/bash
CUDA_VISIBLE_DEVICES=0
log_dir="./results/log"
log_file="$log_dir/embedding.out"
mkdir -p "$log_dir"
exec >"$log_file" 2>&1

datasets=("geo880-standard" "geo880-length_1" "geo880-template_1" "geo880-tmcd_1")

model_names=("local_structure_1")

for dataset in "${datasets[@]}"; do
  for model_name in "${model_names[@]}"; do
    cmd="python embedding_local_structure.py --dataset $dataset --model_name $model_name"
    echo $cmd
    $cmd
  done
done
